/**
 *  Copyright 2002-2023 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef _SEBIE_HELPERS_H_
#define _SEBIE_HELPERS_H_  1

#include <gdk/gdk.h>

struct sebie_s;

void
sebie_set_string(gchar **old_text, const gchar *new_text);

void
sebie_error(const char *format, ...) __attribute__((format(printf,1,2)));

void
sebie_debug(const char *format, ...) __attribute__((format(printf,1,2)));

void
sebie_regcomp(struct sebie_s *sebie);

gboolean
sebie_compare_eq_double(double d1, double d2, double epsilon);

#endif /* _SEBIE_HELPERS_H_ */
