/**
 *  Copyright 2002-2022 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "config.h"
#include "sebie_view.h"
#include "sebie_callbacks.h"


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    g_object_ref (widget), (GDestroyNotify) g_object_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


GtkWidget *
init_sebie_view(struct sebie_s *sebie)
{
#if GTK_CHECK_VERSION(4,0,0)
#elif GTK_CHECK_VERSION(3,0,0)
  GtkToolItem *tmp_tool_item;
#endif

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.window1 = gtk_window_new ();
#else
  sebie->view.window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
#endif
  gchar * window1_title = "SeBIE " PACKAGE_VERSION ;
  gtk_widget_set_name (sebie->view.window1, window1_title);
  gtk_window_set_title (GTK_WINDOW (sebie->view.window1), window1_title);

#if GTK_CHECK_VERSION(3,0,0)
  sebie->view.grid1 = gtk_grid_new ();
  gtk_grid_set_column_homogeneous (GTK_GRID(sebie->view.grid1), FALSE);
  gtk_grid_set_row_homogeneous (GTK_GRID(sebie->view.grid1), FALSE);
  gtk_widget_show (sebie->view.grid1);
#else
  sebie->view.vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (sebie->view.vbox1);
#endif

#if GTK_CHECK_VERSION(4,0,0)
  gtk_window_set_child( GTK_WINDOW (sebie->view.window1), sebie->view.grid1);
#else
#if GTK_CHECK_VERSION(3,0,0)
  gtk_container_add (GTK_CONTAINER (sebie->view.window1), sebie->view.grid1);
#else
  gtk_container_add (GTK_CONTAINER (sebie->view.window1), sebie->view.vbox1);
#endif
#endif

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.toolbar1 = gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#else
  sebie->view.toolbar1 = gtk_toolbar_new ();
#endif
  gtk_widget_show (sebie->view.toolbar1);
#if GTK_CHECK_VERSION(3,0,0)
  gtk_grid_attach (GTK_GRID (sebie->view.grid1), sebie->view.toolbar1, 0, 0, 2, 1);
  gtk_widget_set_hexpand(sebie->view.toolbar1, TRUE);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox1), sebie->view.toolbar1, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (sebie->view.toolbar1), GTK_TOOLBAR_BOTH);
#endif

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.button_quit = gtk_button_new_with_label (_("Quit"));
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.button_quit);
#elif GTK_CHECK_VERSION(3,0,0)
  sebie->view.button_quit =  gtk_tool_button_new(NULL, _("Quit"));
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.button_quit, -1);
#else
  sebie->view.button_quit = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                                        GTK_TOOLBAR_CHILD_BUTTON,
                                                        NULL,
                                                        _("Quit"),
                                                        NULL, NULL,
                                                        NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
#endif
  gtk_widget_show (GTK_WIDGET(sebie->view.button_quit));

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.button_save = gtk_button_new_with_label (_("Save"));
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.button_save);
#elif GTK_CHECK_VERSION(3,0,0)
  sebie->view.button_save =  gtk_tool_button_new(NULL, _("Save"));
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.button_save, -1);
#else
  sebie->view.button_save = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Save"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
#endif
  gtk_widget_show (GTK_WIDGET(sebie->view.button_save));

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.button_rotate_left = gtk_button_new_with_label (_("<- Rotate"));
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.button_rotate_left);
#elif GTK_CHECK_VERSION(3,0,0)
  sebie->view.button_rotate_left =  gtk_tool_button_new(NULL, _("<- Rotate"));
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.button_rotate_left, -1);
#else
  sebie->view.button_rotate_left = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("<- Rotate"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
#endif
  gtk_widget_show (GTK_WIDGET(sebie->view.button_rotate_left));

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.button_rotate_right = gtk_button_new_with_label (_("Rotate ->"));
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.button_rotate_right);
#elif GTK_CHECK_VERSION(3,0,0)
  sebie->view.button_rotate_right =  gtk_tool_button_new(NULL, _("Rotate ->"));
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.button_rotate_right, -1);
#else
  sebie->view.button_rotate_right = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Rotate ->"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
#endif
  gtk_widget_show (GTK_WIDGET(sebie->view.button_rotate_right));

  sebie->view.label_selection_fac_width = gtk_label_new (_(" w:"));
  gtk_widget_show (sebie->view.label_selection_fac_width);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.label_selection_fac_width);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.label_selection_fac_width);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.label_selection_fac_width, NULL, NULL);
#endif
  gtk_label_set_justify (GTK_LABEL (sebie->view.label_selection_fac_width), GTK_JUSTIFY_LEFT);

  sebie->view.entry_selection_fac_width = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_selection_fac_width);

#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.entry_selection_fac_width);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.entry_selection_fac_width);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.entry_selection_fac_width, NULL, NULL);
#endif
  gtk_widget_set_size_request (sebie->view.entry_selection_fac_width, 50, 20);
  gtk_entry_set_max_length (GTK_ENTRY (sebie->view.entry_selection_fac_width), 5);
  sebie->view.label_selection_fac_height = gtk_label_new (_(" h:"));
  gtk_widget_show (sebie->view.label_selection_fac_height);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.label_selection_fac_height);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.label_selection_fac_height);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.label_selection_fac_height, NULL, NULL);
#endif
  gtk_label_set_justify (GTK_LABEL (sebie->view.label_selection_fac_height), GTK_JUSTIFY_LEFT);

  sebie->view.entry_selection_fac_height = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_selection_fac_height);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.entry_selection_fac_height);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.entry_selection_fac_height);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.entry_selection_fac_height, NULL, NULL);
#endif
  gtk_widget_set_size_request (sebie->view.entry_selection_fac_height, 50, 20);
  gtk_entry_set_max_length (GTK_ENTRY (sebie->view.entry_selection_fac_height), 5);

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.button_fac_swap = gtk_button_new_with_label (_("Swap"));
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.button_fac_swap);
#elif GTK_CHECK_VERSION(3,0,0)
  sebie->view.button_fac_swap =  gtk_tool_button_new(NULL, _("Swap"));
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.button_fac_swap, -1);
#else
  sebie->view.button_fac_swap = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Swap"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
#endif
  gtk_widget_show (GTK_WIDGET(sebie->view.button_fac_swap));

  sebie->view.label_selection_fac = gtk_label_new (_("label1"));
  gtk_widget_show (sebie->view.label_selection_fac);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.label_selection_fac);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.label_selection_fac);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.label_selection_fac, NULL, NULL);
#endif
  gtk_label_set_justify (GTK_LABEL (sebie->view.label_selection_fac), GTK_JUSTIFY_LEFT);

  sebie->view.label_selection_gamma = gtk_label_new (_(" gamma:"));
  gtk_widget_show (sebie->view.label_selection_gamma);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.label_selection_gamma);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.label_selection_gamma);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.label_selection_gamma, NULL, NULL);
#endif
  gtk_label_set_justify (GTK_LABEL (sebie->view.label_selection_gamma), GTK_JUSTIFY_LEFT);

  sebie->view.entry_selection_gamma = gtk_spin_button_new_with_range(0.1, 3.0, 0.1);
  gtk_widget_show (sebie->view.entry_selection_gamma);

#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.entry_selection_gamma);
#elif GTK_CHECK_VERSION(3,0,0)
  tmp_tool_item = gtk_tool_item_new();
  gtk_container_add(GTK_CONTAINER(tmp_tool_item), sebie->view.entry_selection_gamma);
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), tmp_tool_item, -1);
  gtk_widget_show(GTK_WIDGET(tmp_tool_item));
#else
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.entry_selection_gamma, NULL, NULL);
#endif
  gtk_widget_set_size_request (sebie->view.entry_selection_gamma, 50, 20);
#if GTK_CHECK_VERSION(4,0,0)
#else
  gtk_entry_set_max_length (GTK_ENTRY (sebie->view.entry_selection_gamma), 5);
#endif

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.button_grayscale = gtk_toggle_button_new_with_label (_("Grayscale"));
  gtk_box_append( GTK_BOX(sebie->view.toolbar1), sebie->view.button_grayscale);
#elif GTK_CHECK_VERSION(3,0,0)
  sebie->view.button_grayscale = gtk_toggle_tool_button_new();
  gtk_tool_button_set_label(GTK_TOOL_BUTTON(sebie->view.button_grayscale), _("Grayscale"));
  gtk_toolbar_insert (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.button_grayscale, -1);
#else
  sebie->view.button_grayscale = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                                             GTK_TOOLBAR_CHILD_TOGGLEBUTTON,
                                                             NULL,
                                                             _("Grayscale"),
                                                             NULL, NULL,
                                                             NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
#endif
  gtk_widget_show (GTK_WIDGET(sebie->view.button_grayscale));

#if !GTK_CHECK_VERSION(3,0,0)
  sebie->view.hpaned1 = gtk_hpaned_new ();
  gtk_widget_show (sebie->view.hpaned1);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox1), sebie->view.hpaned1, TRUE, TRUE, 0);
#endif

#if GTK_CHECK_VERSION(3,0,0)
  sebie->view.vbox2 = gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#else
  sebie->view.vbox2 = gtk_vbox_new (FALSE, 0);
#endif
  gtk_widget_show (sebie->view.vbox2);
#if GTK_CHECK_VERSION(3,0,0)
  gtk_grid_attach (GTK_GRID (sebie->view.grid1), sebie->view.vbox2, 0, 1, 1, 1);
  gtk_widget_set_size_request (sebie->view.vbox2, 150, -1);
  gtk_widget_set_hexpand(sebie->view.vbox2, FALSE);
  gtk_widget_set_vexpand(sebie->view.vbox2, TRUE);
#else
  gtk_paned_pack1 (GTK_PANED (sebie->view.hpaned1), sebie->view.vbox2, FALSE, TRUE);
#endif
  sebie->view.label_input_path = gtk_label_new ("Path:");
  gtk_widget_show (sebie->view.label_input_path);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.label_input_path);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_input_path, FALSE, FALSE, 0);
#endif

  sebie->view.entry_input_path = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_input_path);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.entry_input_path);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_input_path, FALSE, FALSE, 0);
#endif

  sebie->view.label_input_regex = gtk_label_new ("Regex:");
  gtk_widget_show (sebie->view.label_input_regex);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.label_input_regex);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_input_regex, FALSE, FALSE, 0);
#endif

  sebie->view.entry_input_regex = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_input_regex);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.entry_input_regex);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_input_regex, FALSE, FALSE, 0);
#endif

  sebie->view.label_output_format = gtk_label_new ("Output Format:");
  gtk_widget_show (sebie->view.label_output_format);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.label_output_format);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_output_format, FALSE, FALSE, 0);
#endif

  sebie->view.entry_output_format = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_output_format);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.entry_output_format);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_output_format, FALSE, FALSE, 0);
#endif

  sebie->view.label_output_file = gtk_label_new ("Output:");
  gtk_widget_show (sebie->view.label_output_file);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.label_output_file);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_output_file, FALSE, FALSE, 0);
#endif

  sebie->view.entry_output_file = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_output_file);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.entry_output_file);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_output_file, FALSE, FALSE, 0);
#endif

#if GTK_CHECK_VERSION(4,0,0)
  sebie->view.scrolledwindow1 = gtk_scrolled_window_new ();
  gtk_widget_set_vexpand(sebie->view.scrolledwindow1, TRUE);

#else
  sebie->view.scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
#endif
  gtk_widget_show (sebie->view.scrolledwindow1);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_box_append( GTK_BOX(sebie->view.vbox2), sebie->view.scrolledwindow1);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.scrolledwindow1, TRUE, TRUE, 0);
#endif

  sebie->view.treeview_file_list = gtk_tree_view_new ();
  gtk_tree_view_set_model(GTK_TREE_VIEW(sebie->view.treeview_file_list), GTK_TREE_MODEL(sebie->model.file_list));

  gtk_widget_show (sebie->view.treeview_file_list);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_scrolled_window_set_child( GTK_SCROLLED_WINDOW (sebie->view.scrolledwindow1), sebie->view.treeview_file_list);
#else
  gtk_container_add (GTK_CONTAINER (sebie->view.scrolledwindow1), sebie->view.treeview_file_list);
#endif
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("InputFile", renderer, "text", 0, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(sebie->view.treeview_file_list), column);

  sebie->view.drawingarea1 = gtk_drawing_area_new ();
  gtk_widget_show (sebie->view.drawingarea1);
#if GTK_CHECK_VERSION(3,0,0)
  gtk_grid_attach (GTK_GRID (sebie->view.grid1), sebie->view.drawingarea1, 1, 1, 1, 1);
  gtk_widget_set_hexpand(sebie->view.drawingarea1, TRUE);
  gtk_widget_set_vexpand(sebie->view.drawingarea1, TRUE);
  gtk_widget_set_size_request (sebie->view.drawingarea1, sebie->model.window1_width - 150, -1 /*sebie->model.window1_height - 50*/);
#else
  gtk_paned_pack2 (GTK_PANED (sebie->view.hpaned1), sebie->view.drawingarea1, TRUE, TRUE);
#endif

  gtk_window_set_default_size(GTK_WINDOW (sebie->view.window1),
                              sebie->model.window1_width,
                              sebie->model.window1_height);

  sebie->view.statusbar1 = gtk_statusbar_new ();
  gtk_widget_show (sebie->view.statusbar1);
  sebie->view.statusbar1_context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(sebie->view.statusbar1), "SomeContext");
#if GTK_CHECK_VERSION(3,0,0)
  gtk_grid_attach (GTK_GRID (sebie->view.grid1), sebie->view.statusbar1, 0, 2, 2, 1);
  gtk_widget_set_hexpand(sebie->view.statusbar1, TRUE);
#else
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox1), sebie->view.statusbar1, FALSE, FALSE, 0);
#endif

  GtkTreeSelection *select = gtk_tree_view_get_selection(GTK_TREE_VIEW(sebie->view.treeview_file_list));
  gtk_tree_selection_set_mode(select, GTK_SELECTION_SINGLE);
  g_signal_connect(G_OBJECT(select), "changed",
                   G_CALLBACK(on_treeview_file_list_changed),
                   sebie);
  g_signal_connect ((gpointer) sebie->view.entry_input_path, "changed",
                    G_CALLBACK (on_entry_input_path_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.entry_input_regex, "changed",
                    G_CALLBACK (on_entry_input_regex_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.entry_output_format, "changed",
                    G_CALLBACK (on_entry_output_format_changed),
                    sebie);

#if GTK_CHECK_VERSION(4,0,0)
  g_signal_connect (G_OBJECT (sebie->view.window1), "close-request",
                    G_CALLBACK (window1_delete_event), NULL);
#else
  g_signal_connect (G_OBJECT (sebie->view.window1), "delete-event",
                    G_CALLBACK (window1_delete_event), NULL);
#endif
  g_signal_connect (G_OBJECT (sebie->view.window1), "destroy",
                    G_CALLBACK (window1_destroy), NULL);

#if GTK_CHECK_VERSION(4,0,0)
  g_signal_connect (G_OBJECT (sebie->view.drawingarea1), "resize",
                    G_CALLBACK (drawingarea1_resize), sebie);
#else
  g_signal_connect (G_OBJECT (sebie->view.drawingarea1), "size-allocate",
                    G_CALLBACK (drawingarea1_size_allocate), sebie);
#endif

  g_signal_connect ((gpointer) sebie->view.button_quit, "clicked",
                    G_CALLBACK (on_button_quit_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_save, "clicked",
                    G_CALLBACK (on_button_save_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_rotate_left, "clicked",
                    G_CALLBACK (on_button_rotate_left_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_rotate_right, "clicked",
                    G_CALLBACK (on_button_rotate_right_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_fac_swap, "clicked",
                    G_CALLBACK (on_button_fac_swap),
                    sebie);
#if GTK_CHECK_VERSION(4,0,0)
  gtk_drawing_area_set_draw_func (GTK_DRAWING_AREA (sebie->view.drawingarea1), drawingarea1_draw_function, sebie, NULL);
#elif GTK_CHECK_VERSION(3,0,0)
  g_signal_connect ((gpointer) sebie->view.drawingarea1, "draw",
                    G_CALLBACK (on_drawingarea1_expose_event),
                    sebie);
#else
  g_signal_connect ((gpointer) sebie->view.drawingarea1, "expose_event",
                    G_CALLBACK (on_drawingarea1_expose_event),
                    sebie);
#endif
#if GTK_CHECK_VERSION(4,0,0)
  GtkGesture *drag = gtk_gesture_drag_new ();
  gtk_gesture_single_set_button (GTK_GESTURE_SINGLE (drag), GDK_BUTTON_PRIMARY);
  gtk_widget_add_controller (sebie->view.drawingarea1, GTK_EVENT_CONTROLLER (drag));
  g_signal_connect (drag, "drag-begin", G_CALLBACK (on_drawingarea1_drag_begin), sebie);
  g_signal_connect (drag, "drag-update", G_CALLBACK (on_drawingarea1_drag_update), sebie);
  g_signal_connect (drag, "drag-end", G_CALLBACK (on_drawingarea1_drag_end), sebie);

  GtkEventController* motion_controller = gtk_event_controller_motion_new();
  g_signal_connect (motion_controller, "motion", G_CALLBACK (on_drawingarea1_motion), sebie);
  gtk_widget_add_controller (sebie->view.drawingarea1, motion_controller);
#else
  g_signal_connect ((gpointer) sebie->view.drawingarea1, "button_press_event",
                    G_CALLBACK (on_drawingarea1_button_press_event),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.drawingarea1, "motion_notify_event",
                    G_CALLBACK (on_drawingarea1_motion_notify_event),
                    sebie);
#endif
  g_signal_connect ((gpointer) sebie->view.entry_selection_fac_width, "changed",
                    G_CALLBACK (on_entry_selection_fac_width_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.entry_selection_fac_height, "changed",
                    G_CALLBACK (on_entry_selection_fac_height_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.entry_selection_gamma, "changed",
                    G_CALLBACK (on_entry_selection_gamma_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_grayscale, "clicked",
                    G_CALLBACK (on_button_grayscale_clicked),
                    sebie);

#if !GTK_CHECK_VERSION(4,0,0)
  gtk_widget_set_events (sebie->view.drawingarea1, GDK_EXPOSURE_MASK
                         | GDK_LEAVE_NOTIFY_MASK
                         | GDK_BUTTON_PRESS_MASK
                         | GDK_POINTER_MOTION_MASK
                         | GDK_POINTER_MOTION_HINT_MASK);
#endif

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (sebie->view.window1, sebie->view.window1, "window1");
#if GTK_CHECK_VERSION(3,0,0)
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.grid1, "grid1");
#else
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.vbox1, "vbox1");
#endif
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.toolbar1, "toolbar1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_quit, "button_quit");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_save, "button_save");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_rotate_left, "button_rotate_left");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_rotate_right, "button_rotate_right");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_selection_fac_width, "entry_selection_fac_width");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_selection_fac_height, "entry_selection_fac_height");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_fac_swap, "button_frac_swap");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.label_selection_fac, "label_selection_fac");
#if !GTK_CHECK_VERSION(3,0,0)
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.hpaned1, "hpaned1");
#endif
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_input_path, "entry_input_path");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_output_file, "entry_output_file");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.treeview_file_list, "treeview_file_list");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.drawingarea1, "drawingarea1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.statusbar1, "statusbar1");

  return sebie->view.window1;
}
