/**
 *  Copyright 2002-2022 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "sebie_helpers.h"
#include "sebie.h"

#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>


void
sebie_set_string(gchar **old_text, const gchar *new_text)
{
  if (*old_text != NULL) {
    g_free(*old_text);
  }
  *old_text = g_strdup(new_text);
}

void
sebie_error(const char *format, ...)
{
  va_list ap;
  va_start(ap, format);
  vfprintf(stderr, format, ap);
  va_end(ap);
}

void
sebie_debug(const char *format, ...)
{
  char *sebie_debug;

  if ((sebie_debug = getenv("SEBIE_DEBUG")) != NULL) {
    va_list ap;
    va_start(ap, format);
    vprintf(format, ap);
    va_end(ap);
  }
}

void
sebie_regcomp(struct sebie_s *sebie)
{
  int err;
  if ((err = regcomp(&sebie->model.regex, sebie->model.input_regex, 0)) != 0) {
    char buf[256];
    regerror(err, &sebie->model.regex, buf, 256);
    fprintf(stderr, "Error: regcomp failed (%s)\n", buf);
    sebie->model.regex_status = 0;
    return;
  }
  sebie->model.regex_status = 1;
}
