# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: BSD-3-Clause

# [FindGT3.cmake adjusted for GTK4]

find_package(PkgConfig QUIET)

set(__gtk4_required_version "${${CMAKE_FIND_PACKAGE_NAME}_FIND_VERSION}")
if(__gtk4_required_version)
    set(__gtk4_required_version " >= ${__gtk4_required_version}")
endif()
pkg_check_modules(GTK4 "gtk4${__gtk4_required_version}" IMPORTED_TARGET)

if (NOT TARGET PkgConfig::GTK4)
    set(GTK4_FOUND 0)
endif()
unset(__gtk4_required_version)
