/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "sebie_gtk_helpers.h"

#include <math.h>


GdkPixbuf *
rotate_pixbuf(GdkPixbuf *pixbuf, int rotation)
{
  gint new_width;
  gint new_height;

  if (rotation == SEBIE_ROTATE_180) {
    new_width = gdk_pixbuf_get_width(pixbuf);
    new_height = gdk_pixbuf_get_height(pixbuf);
  } else {
    new_width = gdk_pixbuf_get_height(pixbuf);
    new_height = gdk_pixbuf_get_width(pixbuf);
  }
  
  GdkPixbuf *rotated = gdk_pixbuf_new(gdk_pixbuf_get_colorspace(pixbuf),
				      gdk_pixbuf_get_has_alpha(pixbuf),
				      gdk_pixbuf_get_bits_per_sample(pixbuf),
				      new_width,
				      new_height);
  
  guchar *orig = gdk_pixbuf_get_pixels(pixbuf);
  guchar *rota = gdk_pixbuf_get_pixels(rotated);
  
  int width  = gdk_pixbuf_get_width(pixbuf);;
  int height = gdk_pixbuf_get_height(pixbuf);
  int rowstride_o = gdk_pixbuf_get_rowstride(pixbuf);
  int rowstride_r = gdk_pixbuf_get_rowstride(rotated);
  int channels = gdk_pixbuf_get_n_channels(pixbuf);
  int i,j;

  if (rotation == SEBIE_ROTATE_270) {
    for (i = 0; i < width; i++) {
      for (j = 0; j < height; j++) {
	rota[ j * channels + (width - i - 1) * rowstride_r + 0 ] = orig[ i * channels + j * rowstride_o + 0 ];
	rota[ j * channels + (width - i - 1) * rowstride_r + 1 ] = orig[i * channels +  j * rowstride_o + 1 ];
	rota[ j * channels + (width - i - 1) * rowstride_r + 2 ] = orig[i * channels +  j * rowstride_o + 2 ];
      }
    }
  } else if (rotation == SEBIE_ROTATE_090) {
    for (i = 0; i < width; i++) {
      for (j = 0; j < height; j++) {
	rota[ (height - j -1) * channels + i * rowstride_r + 0 ] = orig[ i * channels + j * rowstride_o + 0 ];
	rota[  (height - j -1)* channels + i * rowstride_r + 1 ] = orig[i * channels +  j * rowstride_o + 1 ];
	rota[ (height - j -1) * channels + i * rowstride_r + 2 ] = orig[i * channels +  j * rowstride_o + 2 ];
      }
    }
  } else if (rotation == SEBIE_ROTATE_180) {
    for (i = 0; i < width; i++) {
      for (j = 0; j < height; j++) {
	rota[ (width - i - 1) * channels + (height - j - 1) * rowstride_r + 0 ] = orig[ i * channels + j * rowstride_o + 0 ];
	rota[  (width - i - 1)* channels + (height - j - 1) * rowstride_r + 1 ] = orig[i * channels +  j * rowstride_o + 1 ];
	rota[ (width - i - 1) * channels + (height - j - 1) * rowstride_r + 2 ] = orig[i * channels +  j * rowstride_o + 2 ];
      }
    }
  }
  
  return rotated;
}

GdkPixbuf *
pixbuf_color_corrections(GdkPixbuf *pixbuf, double gamma, int grayscale)
{
  if (gamma == 1.0 && grayscale == 0) {
    return gdk_pixbuf_copy(pixbuf);
  } else {
    GdkPixbuf *corrected = gdk_pixbuf_new(gdk_pixbuf_get_colorspace(pixbuf),
					  gdk_pixbuf_get_has_alpha(pixbuf),
					  gdk_pixbuf_get_bits_per_sample(pixbuf),
					  gdk_pixbuf_get_width(pixbuf),
					  gdk_pixbuf_get_height(pixbuf));
    
    //int bits_per_sample = gdk_pixbuf_get_bits_per_sample(pixbuf);
    int width  = gdk_pixbuf_get_width(pixbuf);;
    int height = gdk_pixbuf_get_height(pixbuf);
    int rowstride_o = gdk_pixbuf_get_rowstride(pixbuf);
    int rowstride_c = gdk_pixbuf_get_rowstride(corrected);
    int channels = gdk_pixbuf_get_n_channels(pixbuf);
    guchar *orig = gdk_pixbuf_get_pixels(pixbuf);
    guchar *corr = gdk_pixbuf_get_pixels(corrected);
    int i, j;
    guchar *gamma_lut;
    
    gamma_lut = g_malloc0(256);
    // compute gamma_lut
    for (i = 0; i < 256; i++) {
      double luv = pow ((double) i / 256.0, 1.0 / gamma) * 256.0;
      guchar lut;
      if (luv < 0.0) {
	lut = 0.0;
      } else if (luv > 255.0) {
	lut = 255.0;
      } else {
	lut = (guchar)luv;
      }
      gamma_lut[i] = luv;
    }
    
    // apply gamma_lut
    for (i = 0; i < width; i++) {
      for (j=0; j < height; j++ ) {
	corr[i * channels + j * rowstride_c + 0] = gamma_lut[orig[i * channels + j * rowstride_o + 0]];
	corr[i * channels + j * rowstride_c + 1] = gamma_lut[orig[i * channels + j * rowstride_o + 1]];
	corr[i * channels + j * rowstride_c + 2] = gamma_lut[orig[i * channels + j * rowstride_o + 2]];
	if (grayscale) {
	  guint grayvalue = (corr[i * channels + j * rowstride_c + 0] + corr[i * channels + j * rowstride_c + 1] + corr[i * channels + j * rowstride_c + 2]) / 3;
	  corr[i * channels + j * rowstride_c + 0] = grayvalue;
	  corr[i * channels + j * rowstride_c + 1] = grayvalue;
	  corr[i * channels + j * rowstride_c + 2] = grayvalue;
	  
	}
      }
    }
    g_free(gamma_lut);
    return corrected;
  }
}
