/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef _SEBIE_CALLBACKS_H_
#define _SEBIE_CALLBACKS_H_  1

#include "sebie.h"

void
on_treeview_file_list_changed(GtkTreeSelection *selection,
			      gpointer user_data);

void
on_entry_input_path_changed (GtkEditable *editable,
			     gpointer    user_data);

void
on_entry_input_regex_changed (GtkEditable *editable,
			      gpointer    user_data);

void
on_entry_output_format_changed (GtkEditable *editable,
				gpointer    user_data);

void
on_button_quit_clicked (GtkButton *button,
			gpointer  user_data);

void
on_button_save_clicked (GtkButton *button,
			gpointer  user_data);

void
on_button_rotate_left_clicked (GtkButton *button,
			       gpointer  user_data);

void
on_button_rotate_right_clicked (GtkButton *button,
				gpointer  user_data);

void
on_entry_selection_fac_width_changed (GtkEditable *editable,
				      gpointer  user_data);

void
on_entry_selection_fac_height_changed (GtkEditable *editable,
				       gpointer  user_data);

void
on_button_fac_swap (GtkButton *button,
		    gpointer  user_data);

void
on_entry_selection_gamma_changed (GtkEditable *editable,
				  gpointer  user_data);

gboolean
on_drawingarea1_expose_event (GtkWidget       *widget,
			      GdkEventExpose  *event,
			      gpointer         user_data);

gboolean
on_drawingarea1_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data);

gboolean
on_drawingarea1_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data);


#endif /* _SEBIE_CALLBACKS_H_ */
