/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#include "sebie_view.h"
#include "sebie_callbacks.h"


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


GtkWidget *
init_sebie_view(struct sebie_s *sebie)
{
  GtkWidget *tmp_toolbar_icon;
  
  sebie->view.window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (sebie->view.window1), _("window1"));
  
  sebie->view.vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (sebie->view.vbox1);
  gtk_container_add (GTK_CONTAINER (sebie->view.window1), sebie->view.vbox1);
  
  sebie->view.toolbar1 = gtk_toolbar_new ();
  gtk_widget_show (sebie->view.toolbar1);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox1), sebie->view.toolbar1, FALSE, FALSE, 0);
  gtk_toolbar_set_style (GTK_TOOLBAR (sebie->view.toolbar1), GTK_TOOLBAR_BOTH);

#ifdef USE_ICON
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-quit", gtk_toolbar_get_icon_size (GTK_TOOLBAR (sebie->view.toolbar1)));
#else
  tmp_toolbar_icon = NULL;
#endif
  sebie->view.button_quit = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
						   GTK_TOOLBAR_CHILD_BUTTON,
						   NULL,
						   _("Quit"),
						   NULL, NULL,
						   tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button_quit);

#ifdef USE_ICON
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-open", gtk_toolbar_get_icon_size (GTK_TOOLBAR (sebie->view.toolbar1)));
#else
  tmp_toolbar_icon = NULL;
#endif

#if 0
  sebie->view.button_load = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Load"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button_load);
#endif

#ifdef USE_ICON
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-save", gtk_toolbar_get_icon_size (GTK_TOOLBAR (sebie->view.toolbar1)));
#else
  tmp_toolbar_icon = NULL;
#endif

  sebie->view.button_save = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Save"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button_save);

#ifdef USE_ICON
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-go-back", gtk_toolbar_get_icon_size (GTK_TOOLBAR (sebie->view.toolbar1)));
#else
  tmp_toolbar_icon = NULL;
#endif

  sebie->view.button_rotate_left = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("<- Rotate "),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button_rotate_left);

#ifdef USE_ICON
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-go-forward", gtk_toolbar_get_icon_size (GTK_TOOLBAR (sebie->view.toolbar1)));
#else
  tmp_toolbar_icon = NULL;
#endif

  sebie->view.button_rotate_right = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Rotate ->"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button_rotate_right);

  sebie->view.entry_selection_fac_width = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_selection_fac_width);
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.entry_selection_fac_width, NULL, NULL);
  gtk_widget_set_size_request (sebie->view.entry_selection_fac_width, 50, 20);
  gtk_entry_set_max_length (GTK_ENTRY (sebie->view.entry_selection_fac_width), 5);
  
  sebie->view.entry_selection_fac_height = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_selection_fac_height);
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.entry_selection_fac_height, NULL, NULL);
  gtk_widget_set_size_request (sebie->view.entry_selection_fac_height, 50, 20);
  gtk_entry_set_max_length (GTK_ENTRY (sebie->view.entry_selection_fac_height), 5);

#ifdef USE_TOOLBAR
  tmp_toolbar_icon = gtk_image_new_from_stock ("gtk-refresh", gtk_toolbar_get_icon_size (GTK_TOOLBAR (sebie->view.toolbar1)));
#else
  tmp_toolbar_icon = NULL;
#endif
 sebie->view.button_fac_swap = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("Swap"),
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button_fac_swap);

  sebie->view.label_selection_fac = gtk_label_new (_("label1"));
  gtk_widget_show (sebie->view.label_selection_fac);
  gtk_toolbar_append_widget (GTK_TOOLBAR (sebie->view.toolbar1), sebie->view.label_selection_fac, NULL, NULL);
  gtk_label_set_justify (GTK_LABEL (sebie->view.label_selection_fac), GTK_JUSTIFY_LEFT);

#if 0
  sebie->view.button7 = gtk_toolbar_append_element (GTK_TOOLBAR (sebie->view.toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("button7"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_label_set_use_underline (GTK_LABEL (((GtkToolbarChild*) (g_list_last (GTK_TOOLBAR (sebie->view.toolbar1)->children)->data))->label), TRUE);
  gtk_widget_show (sebie->view.button7);
#endif

  sebie->view.hpaned1 = gtk_hpaned_new ();
  gtk_widget_show (sebie->view.hpaned1);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox1), sebie->view.hpaned1, TRUE, TRUE, 0);

  sebie->view.vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (sebie->view.vbox2);
  gtk_paned_pack1 (GTK_PANED (sebie->view.hpaned1), sebie->view.vbox2, FALSE, TRUE);

  sebie->view.label_input_path = gtk_label_new ("Path:");
  gtk_widget_show (sebie->view.label_input_path);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_input_path, FALSE, FALSE, 0);

  sebie->view.entry_input_path = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_input_path);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_input_path, FALSE, FALSE, 0);

  sebie->view.label_input_regex = gtk_label_new ("Regex:");
  gtk_widget_show (sebie->view.label_input_regex);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_input_regex, FALSE, FALSE, 0);

  sebie->view.entry_input_regex = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_input_regex);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_input_regex, FALSE, FALSE, 0);

  sebie->view.label_output_format = gtk_label_new ("Output Format:");
  gtk_widget_show (sebie->view.label_output_format);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_output_format, FALSE, FALSE, 0);

  sebie->view.entry_output_format = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_output_format);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_output_format, FALSE, FALSE, 0);

  sebie->view.label_output_file = gtk_label_new ("Output:");
  gtk_widget_show (sebie->view.label_output_file);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.label_output_file, FALSE, FALSE, 0);

  sebie->view.entry_output_file = gtk_entry_new ();
  gtk_widget_show (sebie->view.entry_output_file);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.entry_output_file, FALSE, FALSE, 0);

  sebie->view.scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (sebie->view.scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox2), sebie->view.scrolledwindow1, TRUE, TRUE, 0);

  sebie->view.treeview_file_list = gtk_tree_view_new ();
  gtk_tree_view_set_model(GTK_TREE_VIEW(sebie->view.treeview_file_list), GTK_TREE_MODEL(sebie->model.file_list));

  gtk_widget_show (sebie->view.treeview_file_list);
  gtk_container_add (GTK_CONTAINER (sebie->view.scrolledwindow1), sebie->view.treeview_file_list);
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column;
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("InputFile", renderer, "text", 0, NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(sebie->view.treeview_file_list), column);

  sebie->view.drawingarea1 = gtk_drawing_area_new ();
  gtk_widget_show (sebie->view.drawingarea1);
  gtk_paned_pack2 (GTK_PANED (sebie->view.hpaned1), sebie->view.drawingarea1, TRUE, TRUE);
  gtk_widget_set_size_request (sebie->view.drawingarea1, 1024, 768);

  sebie->view.statusbar1 = gtk_statusbar_new ();
  gtk_widget_show (sebie->view.statusbar1);
  gtk_box_pack_start (GTK_BOX (sebie->view.vbox1), sebie->view.statusbar1, FALSE, FALSE, 0);
  
  GtkTreeSelection *select = gtk_tree_view_get_selection(GTK_TREE_VIEW(sebie->view.treeview_file_list));
  gtk_tree_selection_set_mode(select, GTK_SELECTION_SINGLE);
  g_signal_connect(G_OBJECT(select), "changed",
		   G_CALLBACK(on_treeview_file_list_changed),
		   sebie);
  g_signal_connect ((gpointer) sebie->view.entry_input_path, "changed",
                    G_CALLBACK (on_entry_input_path_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.entry_input_regex, "changed",
                    G_CALLBACK (on_entry_input_regex_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.entry_output_format, "changed",
                    G_CALLBACK (on_entry_output_format_changed),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_quit, "clicked",
                    G_CALLBACK (on_button_quit_clicked),
                    sebie);
#if 0
  g_signal_connect ((gpointer) sebie->view.button_load, "clicked",
                    G_CALLBACK (on_button_load_clicked),
                    sebie);
#endif

  g_signal_connect ((gpointer) sebie->view.button_save, "clicked",
                    G_CALLBACK (on_button_save_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_rotate_left, "clicked",
                    G_CALLBACK (on_button_rotate_left_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_rotate_right, "clicked",
                    G_CALLBACK (on_button_rotate_right_clicked),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.button_fac_swap, "clicked",
                    G_CALLBACK (on_button_fac_swap),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.drawingarea1, "button_press_event",
                    G_CALLBACK (on_drawingarea1_button_press_event),
                    sebie);
  g_signal_connect ((gpointer) sebie->view.drawingarea1, "motion_notify_event",
                    G_CALLBACK (on_drawingarea1_motion_notify_event),
                    sebie);
  
  gtk_widget_set_events (sebie->view.drawingarea1, GDK_EXPOSURE_MASK
			 | GDK_LEAVE_NOTIFY_MASK
			 | GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK
			 | GDK_POINTER_MOTION_HINT_MASK);
  
  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (sebie->view.window1, sebie->view.window1, "window1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.vbox1, "vbox1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.toolbar1, "toolbar1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_quit, "button_quit");
#if 0
  GLADE_HOOKUP_OBJECT (sebie->view.window1,sebie->view. button_load, "button_load");
#endif
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_save, "button_save");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_rotate_left, "button_rotate_left");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_rotate_right, "button_rotate_right");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_selection_fac_width, "entry_selection_fac_width");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_selection_fac_height, "entry_selection_fac_height");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button_fac_swap, "button_frac_swap");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.label_selection_fac, "label_selection_fac");
#if 0
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.button7, "button7");
#endif
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.hpaned1, "hpaned1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.vbox2, "vbox2");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_input_path, "entry_input_path");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.entry_output_file, "entry_output_file");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.treeview_file_list, "treeview_file_list");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.drawingarea1, "drawingarea1");
  GLADE_HOOKUP_OBJECT (sebie->view.window1, sebie->view.statusbar1, "statusbar1");

  //gtk_widget_grab_default (sebie->view.drawingarea1);

  return sebie->view.window1;
}
