/*
 * libpg_ci_diff, a wrapper library to make libci_diff functions
 * accessible from postgres.
 * Copyright (C) 2001 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdlib.h>
#include <string.h>
#include "ci_diff.h"
#include "postgres.h"

/*
 * Wrapper to use ci_diff from within a Postgresql Database.
 * Use:
 *       create function pg_diff(text, text) returns text as
 *         as '<PATH_TO_CI_DIFF>/pg_diff.so' language 'c';
 *       create function pg_patch(text, text) returns text as
 *         as '<PATH_TO_CI_DIFF>/pg_diff.so' language 'c';
 *
 * to create the functions in postgres.
 */

text * pg_diff(text *old, text *new) {
  char *delta;
  size_t delta_len;
  text *delta_text;
  
  //fprintf(stderr, "pg_diff(old='%s'(%d), new='%s'(%d))\n", old->vl_dat, old->vl_len, new->vl_dat, new->vl_len);

  ci_diff_sn(&delta, &delta_len, 
	     old->vl_dat, old->vl_len-4,
	     new->vl_dat, new->vl_len-4);
  
  delta_text = (text*) malloc(sizeof(text) + delta_len);
  delta_text->vl_len = delta_len+4;
  memcpy(delta_text->vl_dat, delta, delta_len);
  
  return delta_text;
}

text * pg_patch(text *old, text *delta) {
  char *new_dat;
  size_t new_len;
  text *new;

  //fprintf(stderr, "pg_patch(old='%s'(%d), delta='%s'(%d))\n", old->vl_dat, old->vl_len, delta->vl_dat, delta->vl_len);

  ci_apply_sn(&new_dat, &new_len, 
	      old->vl_dat, old->vl_len-4,
	      delta->vl_dat, delta->vl_len-4);
  
  new = (text*) malloc(sizeof(text) + new_len);
  new->vl_len = new_len+4;
  memcpy(new->vl_dat, new_dat, new_len);
  
  return new;
}

