/*
 * libci_diff, a library to compute a binary copy/insert diff.
 * Copyright (C) 2001 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "config.h"

#if defined(HAVE_MCHECK_H)
#include <mcheck.h>
#endif

#include <stdio.h>
#include <string.h>
#include <malloc.h>

#include "ci_diff.h"

static char *string_1 = (unsigned char *)"kdjfkasjdfkjasdkf kadfjkasdjf kasdfkjasdk jkasdjfkasdjfk jasdkfjsdakjfkasjdf kadsjfkjasdf kjasdkfjkasdjfk ";

//static char *string_2 = (unsigned char *)"kdjfkasjdfkjasdkf012345678 kadfjkasdjf kasdfkjasdk jkasdjfkasdjkadsjfkjasdf kjasdkfjkasdjfk 012345678";

static char *string_2 = (unsigned char *)"kdjfkasjdfkjasdkf012345678 kadfjkasdjf kasdfkjasdk jkasdjfkasdjkadsjfkjasdf kjasdkfjkas";

static char *string_3 = "huhu";
static char *string_4 = "Hallo";

void test_string(char *s1, char *s2) {
  char *delta;
  char *result;
  int ret;

  printf("test_string:\n");
  printf("s1    : %s\n", s1);

  if ( (ret = ci_diff_s(&delta, s1, s2)) != 0) {
    fprintf(stderr, "Error: ci_diff_s() failed (%s).\n", strerror(ret));
    exit(1);
  }
  
  printf("delta : %s\n", delta);
  
  
  if ( (ret = ci_apply_s(&result, string_1, delta)) != 0) {
   fprintf(stderr, "Error: ci_apply_s() failed (%s).\n", strerror(ret));
   exit(1);
  }
  
  printf("s2    : %s\n", s2);
  printf("result: %s\n", result);
  
  free(delta);
  free(result);
}

void test_string_n(char *s1, size_t n1, char *s2, size_t n2) {
  char *delta;
  size_t delta_len;
  char *result;
  size_t result_len;
  int ret;

  printf("test_string_n:\n");
  printf("s1    : %s\n", s1);

  if ( (ret = ci_diff_sn(&delta, &delta_len, s1, n1, s2, n2)) != 0) {
    fprintf(stderr, "Error: ci_diff_sn() failed (%s).\n", strerror(ret));
    exit(1);
  }
  
  printf("delta : %s\n", delta);
  
  
  if ( (ret = ci_apply_sn(&result, &result_len, s1, n1, delta, delta_len)) != 0) {
    fprintf(stderr, "Error: ci_apply_sn() failed (%s).\n", strerror(ret));
    exit(1);
  }
  
  printf("s2    : %s\n", s2);
  printf("result: %s\n", result);
  
  free(delta);
  free(result);
}

void test_binary(void *s1, size_t n1, void *s2, size_t n2) {
  void *delta;
  size_t delta_len;
  void *result;
  size_t result_len;
  int ret;

  printf("test_binary:\n");
  printf("s1    : %s\n", (char *)s1);

  if ( (ret = ci_diff_b(&delta, &delta_len, s1, n1, s2, n2)) != 0) {
    fprintf(stderr, "Error: ci_diff_b() failed (%s).\n", strerror(ret));
    exit(1);
  }
  
  //printf("delta : %s\n", (char *)delta);
  
  
  if ( (ret = ci_apply_b(&result, &result_len, s1, n1, delta, delta_len)) != 0) {
   fprintf(stderr, "Error: ci_apply_b() failed (%s).\n", strerror(ret));
   exit(1);
  }
  
  printf("s2    : %s\n", (char *)s2);
  printf("result: %s\n", (char *)result);
  
  free(delta);
  free(result);
}


int main(int argc, char **argv) {

#if defined(HAVE_MCHECK_H)
  mtrace();
#endif  

  test_string(string_1, string_2);
  test_string(string_3, string_4);

  test_string_n(string_3, strlen(string_3)+1, string_4, strlen(string_4)+1);
  test_string_n(string_1, strlen(string_1)+1, string_2, strlen(string_2)+1);
  

  test_binary(string_1, strlen(string_1)+1, string_2, strlen(string_2)+1);
  test_binary(string_3, strlen(string_3)+1, string_4, strlen(string_4)+1);
  
  exit(0);
}
