/*
 * libci_diff, a library to compute a binary copy/insert diff.
 * Copyright (C) 2001 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef _CI_HASH_H_
#define _CI_HASH_H_ 1

#include <sys/types.h>

/*
typedef struct ci_hash_entry_s {
  size_t value;
} ci_hash_entry_t;
*/
typedef size_t ci_hash_entry_t;

typedef struct ci_hash_table_s {
  size_t size;
  ci_hash_entry_t **entries; 
} ci_hash_table_t;

ci_hash_table_t * ci_new_hash( size_t size );

void ci_free_hash(ci_hash_table_t *hash_table);

ci_hash_entry_t *ci_find_hash( ci_hash_table_t *hash_table,
			       unsigned long hash );

int ci_insert_hash( ci_hash_table_t *hash_table,
		     unsigned long hash,
		     ci_hash_entry_t entry );

#endif
