/*
 * libci_diff, a library to compute a binary copy/insert diff.
 * Copyright (C) 2001 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "ci_hash.h"

#include <stdio.h>
#include <errno.h>
#include <malloc.h>

ci_hash_table_t * ci_new_hash(size_t size)
{
  ci_hash_table_t *ret;
  if ( (ret = (ci_hash_table_t *) malloc(sizeof(ci_hash_table_t))) == NULL) {
    return NULL;
  }
  ret->size = size;
  if ( (ret->entries = (ci_hash_entry_t **)malloc(sizeof(ci_hash_entry_t *) * size)) == NULL) {
    free(ret);
    return NULL;
  }
  memset(ret->entries, 0, sizeof(ci_hash_entry_t *) * size);
  return ret;
}

void ci_free_hash(ci_hash_table_t *hash_table)
{
  int i;
  
  for (i = 0; i < hash_table->size; i++) {
    if (hash_table->entries[i] != NULL) {
      free(hash_table->entries[i]);
    }
  }
  free(hash_table->entries);
  free(hash_table);
}

int ci_insert_hash( ci_hash_table_t *hash_table,
		    unsigned long hash,
		    ci_hash_entry_t entry )
{
  ci_hash_entry_t *tmp;
  
  if (hash_table->entries[hash%hash_table->size] == NULL) {
    if ( (tmp = (ci_hash_entry_t *)malloc(sizeof(ci_hash_entry_t))) == NULL) {
      return ENOMEM;
    };
    *tmp = entry;
    hash_table->entries[hash%hash_table->size] = tmp;
    printf("hash: %ld entry: %d index: %ld\n", hash, entry, hash%hash_table->size);
  } else {
    printf("hash: %ld entry: %d index: %ld conflict\n", hash, entry, hash%hash_table->size);
  }

  return 0;
}

ci_hash_entry_t *ci_find_hash( ci_hash_table_t *hash_table,
			       unsigned long hash )
{
  if (hash_table->entries[hash%hash_table->size] != NULL) {
    printf(" hash: %ld entry: %d index: %ld\n", hash, *hash_table->entries[hash%hash_table->size], hash%hash_table->size);
  } else {
    printf(" hash: %ld entry: -- index: %ld\n", hash, hash%hash_table->size);
  }
  return hash_table->entries[hash%hash_table->size];
}
