/*
 * libci_diff, a library to compute a binary copy/insert diff.
 * Copyright (C) 2001 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "ci_buf.h"
#include <stdlib.h>

ci_buf_t *ci_new_buf()
{
  ci_buf_t *tmp;
  if ( (tmp = (ci_buf_t *)malloc(sizeof(ci_buf_t))) != NULL) {
    tmp->buf = NULL;
    tmp->buf_pos = 0;
    tmp->buf_len = 0;
  }
  return tmp;
}

void ci_free_buf(ci_buf_t *ptr)
{
  if (ptr->buf != NULL) {
    free(ptr->buf);
  }
  free(ptr);
}

ci_buf_t *ci_append_buf(ci_buf_t *ptr, void *s, size_t n)
{
  void *tmp;
  
  if (ptr->buf_len - ptr->buf_pos < n) {
    if ( (tmp = realloc(ptr->buf, ptr->buf_len + n)) == NULL) {
      ci_free_buf(ptr);
      return NULL;
    }
    ptr->buf = tmp;
  }
  
  memcpy(ptr->buf + ptr->buf_pos, s, n);
  ptr->buf_pos += n;
  ptr->buf_len += n;
  return ptr;
}
