/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
package javacard.framework;

import javacard.framework.APDUException;

public final class APDU extends java.lang.Object {
	static byte PROTOCOL_T0 = 0;
	static byte PROTOCOL_T1 = 1;

	private static byte[] buffer; // = new byte[256];
	private static short outgoingLength = 0;
        private static short receiveBytesLength = 0;

	private APDU() {
		this.buffer = new byte[256];
	}

	public byte[] getBuffer() {
		return this.buffer;
	}

	public static short getInBlockSize() {
		return 1;
	}

	public byte getNAD() {
		return 0;
	}

	public static short getOutBlockSize() {
		return 258;
	}

	public static byte getProtocol() {
		return PROTOCOL_T0;
	}

	public short receiveBytes(short bOff) throws APDUException {
		//return receiveBytesLength;
		return 0; // for now all bytes are read while setIncomingAndReceive
	}

	public void sendBytes(short bOff, short len) throws APDUException {
		
	}

	public void sendBytesLong(byte[] outData, short bOff, short len) throws APDUException {

	}

	public short setIncomingAndReceive() throws APDUException {
		return this.buffer[4];  // Lc
	}

	public short setOutgoing() throws APDUException {
		return 256;
	}

	public void setOutgoingAndSend(short bOff, short len) throws APDUException {

	}

	public void setOutgoingLength(short len) throws APDUException {
		this.outgoingLength = len;
	}

	public short setOutgoingNoChaining() throws APDUException {
		return 256;
	}

	public static void waitExtension() throws APDUException {

	}

	// for the implementation
	public APDU(byte[] buffer) {
		this.buffer = buffer;
		receiveBytesLength = (short)this.buffer.length;
	}
}
