/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
package jardin;

import javacard.framework.Applet;
import javacard.framework.APDU;

public class Jardin {
	static Applet applet;

	public static void run() {
		boolean ret = applet.select();
		byte[] buffer_0 = { (byte)0xb0, // CLA
                                    (byte)0x11, // INS
                                    (byte)0x00, // P1
                                    (byte)0x00, // P2
                                    (byte)0x04, // Lc
                                    (byte)0xde,
                                    (byte)0xad,
                                    (byte)0xbe,
                                    (byte)0xef,
                                    (byte)0x04  // Le
				 };
		APDU appdu_0 = new APDU(buffer_0);
		applet.process(appdu_0);
		applet.deselect();
	}

	public static void setApplet(Applet a) {
		applet = a;
	}
}
