/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
#ifndef JARDIN_JCVM_H
#define JARDIN_JCVM_H 1

#define OPCODE_nop         0x00
#define OPCODE_aconst_null 0x01
#define OPCODE_sconst_m1   0x02
#define OPCODE_sconst_0    0x03
#define OPCODE_sconst_1    0x04
#define OPCODE_sconst_2    0x05
#define OPCODE_sconst_3    0x06
#define OPCODE_sconst_4    0x07
#define OPCODE_sconst_5    0x08
#define OPCODE_iconst_m1   0x09
#define OPCODE_iconst_0    0x0a
#define OPCODE_iconst_1    0x0b
#define OPCODE_iconst_2    0x0c
#define OPCODE_iconst_3    0x0d
#define OPCODE_iconst_4    0x0e
#define OPCODE_iconst_5    0x0f
#define OPCODE_bspush      0x10
#define OPCODE_sspush      0x11
#define OPCODE_bipush      0x12
#define OPCODE_sipush      0x13
#define OPCODE_iipush      0x14
#define OPCODE_aload       0x15
#define OPCODE_sload       0x16
#define OPCODE_iload       0x17
#define OPCODE_aload_0     0x18
#define OPCODE_aload_1     0x19
#define OPCODE_aload_2     0x1a
#define OPCODE_aload_3     0x1b
#define OPCODE_sload_0     0x1c
#define OPCODE_sload_1     0x1d
#define OPCODE_sload_2     0x1e
#define OPCODE_sload_3     0x1f
#define OPCODE_iload_0     0x20
#define OPCODE_iload_1     0x21
#define OPCODE_iload_2     0x22
#define OPCODE_iload_3     0x23
#define OPCODE_aaload      0x24
#define OPCODE_baload      0x25
#define OPCODE_saload      0x26
#define OPCODE_iaload      0x27
#define OPCODE_astore      0x28
#define OPCODE_sstore      0x29
#define OPCODE_istore      0x2a
#define OPCODE_astore_0    0x2b
#define OPCODE_astore_1    0x2c
#define OPCODE_astore_2    0x2d
#define OPCODE_astore_3    0x2e
#define OPCODE_sstore_0    0x2f
#define OPCODE_sstore_1    0x30
#define OPCODE_sstore_2    0x31
#define OPCODE_sstore_3    0x32
#define OPCODE_istore_0    0x33
#define OPCODE_istore_1    0x34
#define OPCODE_istore_2    0x35
#define OPCODE_istore_3    0x36
#define OPCODE_aastore     0x37
#define OPCODE_bastore     0x38
#define OPCODE_sastore     0x39
#define OPCODE_iastore     0x3a
#define OPCODE_pop         0x3b
#define OPCODE_pop2        0x3c
#define OPCODE_dup         0x3d
#define OPCODE_dup2        0x3e
#define OPCODE_dup_x       0x3f
#define OPCODE_swap_x      0x40
#define OPCODE_sadd        0x41
#define OPCODE_iadd        0x42
#define OPCODE_ssub        0x43
#define OPCODE_isub        0x44
#define OPCODE_smul        0x45
#define OPCODE_imul        0x46
#define OPCODE_sdiv        0x47
#define OPCODE_idiv        0x48
#define OPCODE_srem        0x49
#define OPCODE_irem        0x4a
#define OPCODE_sneg        0x4b
#define OPCODE_ineg        0x4c
#define OPCODE_sshl        0x4d
#define OPCODE_ishl        0x4e
#define OPCODE_sshr        0x4f
#define OPCODE_ishr        0x50
#define OPCODE_sushr       0x51
#define OPCODE_iushr       0x52
#define OPCODE_sand        0x53
#define OPCODE_iand        0x54
#define OPCODE_sor         0x55
#define OPCODE_ior         0x56
#define OPCODE_sxor        0x57
#define OPCODE_ixor        0x58
#define OPCODE_sinc        0x59
#define OPCODE_iinc        0x5a
#define OPCODE_s2b         0x5b
#define OPCODE_s2i         0x5c
#define OPCODE_i2b         0x5d
#define OPCODE_i2s         0x5e
#define OPCODE_icmp        0x5f
#define OPCODE_ifeq        0x60
#define OPCODE_ifne        0x61
#define OPCODE_iflt        0x62
#define OPCODE_ifge        0x63
#define OPCODE_ifgt        0x64
#define OPCODE_ifle        0x65
#define OPCODE_ifnull      0x66
#define OPCODE_ifnonull    0x67
#define OPCODE_if_acmpeq   0x68
#define OPCODE_if_acmpne   0x69
#define OPCODE_if_scmpeq   0x6a
#define OPCODE_if_scmpne   0x6b
#define OPCODE_if_scmplt   0x6c
#define OPCODE_if_scmpge   0x6d
#define OPCODE_if_scmpgt   0x6e
#define OPCODE_if_scmple   0x6f
#define OPCODE_goto        0x70
#define OPCODE_jsr         0x71
#define OPCODE_ret         0x72
#define OPCODE_stableswitch   0x73
#define OPCODE_itableswitch   0x74
#define OPCODE_slookupswitch  0x75
#define OPCODE_ilookupswitch  0x76
#define OPCODE_areturn        0x77
#define OPCODE_sreturn        0x78
#define OPCODE_ireturn        0x79
#define OPCODE_return         0x7a
#define OPCODE_getstatic_a    0x7b
#define OPCODE_getstatic_b    0x7c
#define OPCODE_getstatic_s    0x7d
#define OPCODE_getstatic_i    0x7e
#define OPCODE_putstatic_a    0x7f
#define OPCODE_putstatic_b    0x80
#define OPCODE_putstatic_s    0x81
#define OPCODE_putstatic_i    0x82
#define OPCODE_getfield_a     0x83
#define OPCODE_getfield_b     0x84
#define OPCODE_getfield_s     0x85
#define OPCODE_getfield_i     0x86
#define OPCODE_putfield_a     0x87
#define OPCODE_putfield_b     0x88
#define OPCODE_putfield_s     0x89
#define OPCODE_putfield_i     0x8a
#define OPCODE_invokevirtual  0x8b
#define OPCODE_invokespecial  0x8c
#define OPCODE_invokestatic   0x8d
#define OPCODE_invokeinterface  0x8e
#define OPCODE_new             0x8f
#define OPCODE_newarray        0x90
#define OPCODE_anewarray       0x91
#define OPCODE_arraylength     0x92
#define OPCODE_athrow          0x93
#define OPCODE_checkcast       0x94
#define OPCODE_instanceof      0x95
#define OPCODE_sinc_w          0x96
#define OPCODE_iinc_w          0x97
#define OPCODE_ifeq_w          0x98
#define OPCODE_ifne_w          0x99
#define OPCODE_iflt_w          0x9a
#define OPCODE_ifge_w          0x9b
#define OPCODE_ifgt_w          0x9c
#define OPCODE_ifle_w          0x9d
#define OPCODE_ifnull_w        0x9e
#define OPCODE_ifnonull_w      0x9f
#define OPCODE_if_acmpeq_w     0xa0
#define OPCODE_if_acmpne_w     0xa1
#define OPCODE_if_scmpeq_w     0xa2
#define OPCODE_if_scmpne_w     0xa3
#define OPCODE_if_scmplt_w     0xa4
#define OPCODE_if_scmpge_w     0xa5
#define OPCODE_if_scmpgt_w     0xa6
#define OPCODE_if_scmple_w     0xa7
#define OPCODE_goto_w          0xa8
#define OPCODE_getfield_a_w    0xa9
#define OPCODE_getfield_b_w    0xaa
#define OPCODE_getfield_s_w    0xab
#define OPCODE_getfield_i_w    0xac
#define OPCODE_getfield_a_this 0xad
#define OPCODE_getfield_b_this 0xae
#define OPCODE_getfield_s_this 0xaf
#define OPCODE_getfield_i_this 0xb0
#define OPCODE_putfield_a_w    0xb1
#define OPCODE_putfield_b_w    0xb2
#define OPCODE_putfield_s_w    0xb3
#define OPCODE_putfield_i_w    0xb4
#define OPCODE_putfield_a_this 0xb5
#define OPCODE_putfield_b_this 0xb6
#define OPCODE_putfield_s_this 0xb7
#define OPCODE_putfield_i_this 0xb8
#define OPCODE_impdep1         0xfe
#define OPCODE_impdep2         0xff
#define JARDIN_MAX_OPCODE      0x100


/* the jcvm supported java types (chapter 3.1 JCVM) */
typedef signed char     jardin_jcvm_byte;
typedef signed short    jardin_jcvm_short;
typedef signed int      jardin_jcvm_int;
typedef unsigned short  jardin_jcvm_reference;
#define JARDIN_JCVM_TRUE   1
#define JARDIN_JCVM_FALSE  0

/* the jcvm storage unit (chapter 3.2 JCVM) */
typedef unsigned short jardin_jcvm_word;

/* for convenience */
typedef unsigned short jardin_jcvm_index;

struct jardin_jcvm_applet {
  struct jardin_cap *cap;
  jardin_jcvm_word *static_field_image;
};

/* the jcvm frame (chapter 3.5 JCVM) */
struct jardin_jcvm_frame {
  jardin_jcvm_word   *local_variables;
  jardin_jcvm_word   *operand_stack;
  jardin_jcvm_index  operand_stack_index;
  struct jardin_jcvm_applet  *context;
  /* for debug/assert */
  int local_variables_size;
  int operand_stack_size;
  unsigned int pc;
  struct jardin_jcvm_frame *invoker_frame;
};

extern struct jardin_jcvm_applet *jardin_jcvm_applets;

void jardin_jcvm_applet_alloc(unsigned int applet_count);
void jardin_jcvm_applet_free();

void jardin_jcvm_init();
void jardin_jcvm_free();

void jardin_jcvm_run(int applet_index);

#endif /* JARDIN_JCVM_H */
