/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
#ifndef JARDIN_DEBUG_H
#define JARDIN_DEBUG_H

#include <stdio.h>

#define JARDIN_DEBUG(a, ...) fprintf(stdout, "Debug: " a "\n" , ## __VA_ARGS__);
#define JARDIN_ERROR(a, ...) fprintf(stderr, "Error: " a "\n" , ## __VA_ARGS__);
#define JARDIN_FATAL(a, ...) fprintf(stderr, "Error: " a "\n" , ## __VA_ARGS__);exit(1);

void jardin_debug_init();

#endif /* JARDIN_DEBUG_H */
