#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <ppm.h>

#include "blur.h"


int main(int argc, char **argv) {
  
  FILE *in_file;
  FILE *out_file;

  pixel **in_image  = NULL;
  pixel **out_image = NULL;

  pixval maxval = 0;

  int    n_cols = 0;
  int    n_rows = 0;

  if (argc != 3) {
    fprintf(stderr, " Usage blur_3dnow <in_file_name> <out_file_name>\n");
    exit(1);
  }
  
  if ((in_file = fopen(argv[1], "r")) == NULL) {
    fprintf(stderr, "ERROR: open of file %s failed (%s),\n", argv[1], strerror(errno));
    exit(1);
  }

  if ((out_file = fopen(argv[2], "w")) == NULL) {
    fprintf(stderr, "ERROR: open of file %s failed (%s),\n", argv[2], strerror(errno));
    exit(1);
  }

  in_image  = ppm_readppm(in_file, &n_cols, &n_rows, &maxval);
  out_image = ppm_allocarray(n_cols, n_rows);

  
  printf("Algorithm: gaussian blur\n");
  printf("cols: %d rows: %d maxval: %d\n", n_cols, n_rows, maxval);

  do_blur(out_image, in_image, n_cols, n_rows);

  ppm_writeppm(out_file, out_image, n_cols, n_rows, maxval, 0);
  
  exit(0);
}
