#include <stdio.h>
#include <errno.h>
#include <string.h>

#include <ppm.h>

#include "blur.h"

void do_blur(pixel **out_image, pixel **in_image, int n_cols, int n_rows) {
  
  float filter_div          = 16.0;
  float filter_div_rcp      =  0.0;
  static float filter[3][3] = {{1.0, 2.0, 1.0},
			       {2.0, 4.0, 2.0},
			       {1.0, 2.0, 1.0}};

  int x;
  int y;

  int i;
  int j;

  pixel vpix;
  
  float res_r;
  float res_g;
  float res_b;

  int tmp_x;
  int tmp_y;
  
  filter_div_rcp = 1.0 / filter_div;

  for(y = 0; y < n_rows; y++) {
    for(x = 0; x < n_cols; x++) {
      res_r = 0.0;
      res_g = 0.0;
      res_b = 0.0;
      
      for(j = 0; j < 3; j++) {
	for(i = 0; i < 3; i++) {
	  tmp_x = x - (3>>1) + i;
	  tmp_y = y - (3>>1) + j;
	  
	  if (tmp_x < 0) tmp_x = 0;
	  if (tmp_x == n_cols) tmp_x = n_cols - 1;
	  if (tmp_y < 0) tmp_y = 0;
	  if (tmp_y == n_rows) tmp_y = n_rows - 1;
	  
	  vpix = in_image[tmp_y][tmp_x];
	  
	  res_r += (float)PPM_GETR(vpix) * filter[j][i];
	  res_g += (float)PPM_GETG(vpix) * filter[j][i];
	  res_b += (float)PPM_GETB(vpix) * filter[j][i];
	}
      }
      
      res_r *= filter_div_rcp;
      res_g *= filter_div_rcp;
      res_b *= filter_div_rcp;
      
      res_r = (res_r > 255.0)? 255.0: ((res_r<0.0)? 0.0 : res_r);
      res_g = (res_g > 255.0)? 255.0: ((res_g<0.0)? 0.0 : res_g);
      res_b = (res_b > 255.0)? 255.0: ((res_b<0.0)? 0.0 : res_b);
      
      PPM_ASSIGN(out_image[y][x],
		 (pixval) res_r,
		 (pixval) res_g,
		 (pixval) res_b);
    }
  }
}
